// External oscillator frequency
#define SYSCLK          32000000
#include "p24fj128ga008.h"

// Setup configuration bits
_CONFIG1( JTAGEN_OFF & GCP_OFF & GWRP_OFF & COE_OFF & FWDTEN_OFF & ICS_PGx2) 
_CONFIG2( FCKSM_CSDCMD & OSCIOFNC_ON & POSCMOD_HS & FNOSC_PRIPLL )

#define POT 0 // 10k potentiometer connected to AN5 input
#define AINPUTS 0xfffe // Analog inputs on AN0(RB0)


#define   LED   PORTD

#define  DELAY 16000

void delay(void)
{
   TMR1 =0;
   while ( TMR1 < DELAY);  
}


void initADC( int amask)
{
	AD1CON1 = 0x80E4;				//Turn on, auto sample start, auto-convert
	AD1CON2 = 0;					//AVdd, AVss, int every conversion, MUXA only
	AD1CON3 = 0x1F05;				//31 Tad auto-sample, Tad = 5*Tcy       
	AD1CSSL = 0;					//No scanned inputs
} //initADC


int readADC( int ch)
{
	AD1CHS = ch;               // 1. select analog input channel
	AD1CON1bits.SAMP = 1;      // 2. start sampling
	TMR1 = 0;                  // 3. wait for sampling time
	while (TMR1< 500);         //    6.25 us
		AD1CON1bits.DONE = 1;  // 4. start the conversion
	while (!AD1CON1bits.DONE); // 5. wait for the conversion to complete

return ADC1BUF0; // 6. read the conversion result
} // readADC


//--------------------------------------------------------------------------------
int main ()
{   
  
	TRISD = 0x0000;
	TRISB = 0xFFFF;
    T1CON = 0x8030;    // TMR1on, prescaler 1:256 Tclk/2

    initADC( AINPUTS); // initialize the ADC for the Explorer16 analog inputs

	while (1)
	{
        LED = ~readADC(POT); // select the POT input and convert
	
	} // End While
}  // End main
//--------------------------------------------------------------------------------